<?php

namespace April\Payments\Model;

use April\Payments\Helper\Logger;

class AprilCustomer extends \Magento\Framework\Model\AbstractModel
{
    var $_aprilCustomer = null;
    var $_defaultPaymentMethod = null;

    protected $helper;
    protected $customer;
    protected $_customerSession;
    protected $_sessionManager;
    protected $_registry;
    protected $_appState;
    protected $_eventManager;
    protected $_cacheManager;
    protected $_resource;
    protected $_resourceCollection;
    protected $_logger;
    protected $_actionValidator;

    public $customerCard = null;
    public $paymentMethodsCache = [];

    /**
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb $resourceCollection
     * @param array $data
     */
    public function __construct(
        \April\Payments\Model\Customer $customer,
        \April\Payments\Helper\Generic $helper,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Session\SessionManagerInterface $sessionManager,
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        ?\Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        ?\Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->helper = $helper;
        $this->customer = $customer;
        $this->_customerSession = $customerSession;
        $this->_sessionManager = $sessionManager;
        $this->_registry = $registry;
        $this->_appState = $context->getAppState();
        $this->_eventManager = $context->getEventDispatcher();
        $this->_cacheManager = $context->getCacheManager();
        $this->_resource = $resource;
        $this->_resourceCollection = $resourceCollection;
        $this->_logger = $context->getLogger();
        $this->_actionValidator = $context->getActionValidator();

        if ((!is_null($this->_resource) && method_exists($this->_resource, 'getIdFieldName'))
            || $this->_resource instanceof \Magento\Framework\DataObject
        ) {
            $this->_idFieldName = $this->_getResource()->getIdFieldName();
        }

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    protected function _construct()
    {
        $this->_init('April\Payments\Model\ResourceModel\AprilCustomer');
    }

    public function updateSessionId()
    {
        if (!$this->getAprilId()) return;
        if ($this->helper->isAdmin()) return;

        $sessionId = $this->_customerSession->getSessionId();
        if ($sessionId != $this->getSessionId()) {
            $this->setSessionId($sessionId);
            $this->save();
        }
    }

    public function signInCustomer()
    {
        if (!$this->getAprilId()) {
            $this->createAprilCustomer();
        }

        $resp = $this->customer->signin($this->getAprilId());
        $customToken = $resp['customToken'];

        return $customToken;
    }

    public function createAprilCustomer()
    {
        $params = $this->getAprilCustomerParams();

        return $this->createNewAprilCustomer($params);
    }

    public function getAprilCustomerParams()
    {
        $params = [];

        $customer = $this->helper->getMagentoCustomer();

        if ($customer) {
            $params = [
                'firstName' => $customer->getFirstname(),
                'lastName' => $customer->getLastname(),
                'emailAddress' => $customer->getEmail(),
                'customerId' => $customer->getEntityId()
            ];

            return $params;
        } else {
            throw new \Magento\Framework\Exception\Exception('Cannot create April accounts for unregistered users');
        }
    }

    public function createNewAprilCustomer($params)
    {
        $aprilCustomerId = $this->customer->create($params);

        $this->setAprilId($aprilCustomerId);
        $this->setPublicKey($this->helper->getPublishableKey());
        $this->setCustomerId($params['customerId']);
        $this->setCustomerEmail($params['emailAddress']);

        $this->save();

        return null;
    }
}
