<?php

namespace April\Payments\Model;

use April\Payments\Helper;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class Config
{
    protected $scopeConfig;
    protected $helper;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        \April\Payments\Helper\Config $helper
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->helper = $helper;
    }

    public function getConfigData($method_code, $field, $storeId = null)
    {
        $code = $method_code;
        if (empty($storeId))
            $storeId = $this->helper->getStoreId();

        $defaultAprilConfig = [
            'active',
            'publishablekey',
            'secretkey',
            'payment_action',
            'order_status',
            'request_3ds',
            'available_payment_options',
            'individual_payment_options',
            'wallet_payments_place_order',
            'save_card_in_checkout',
            'minimum_amount_3ds'
        ];
        if (in_array($field, $defaultAprilConfig))
            $code = 'aprilpayments';

        $path = 'payment/' . $code . '/' . $field;
        $value = $this->scopeConfig->getValue($path, ScopeInterface::SCOPE_STORE, $storeId);

        return $value;
    }

    public function getAprilEnvToUse()
    {
        $publishableKey = $this->getConfigData('aprilpayments', 'publishablekey');
        $pkExp = explode('_', $publishableKey);
        $env = $pkExp[0];
        return $env;
    }

    public function isAprilProdEnv()
    {
        $env = $this->getAprilEnvToUse();
        return $env === 'live';
    }
}
