<?php

namespace April\Payments\Model\Config;

use Magento\Checkout\Model\ConfigProviderInterface;
use April\Payments\Model\Config;
use April\Payments\Helper\Logger as LpLogger;

/**
 * Class CheckoutConfigProvider
 */
class CheckoutConfigProvider implements ConfigProviderInterface
{
    protected $config;
    protected $helper;
    protected $customer;

    /**
     * @param CurrentCustomer $currentCustomer
     * @param AgreementFactory $agreementFactory
     */
    public function __construct(
        \April\Payments\Model\Config $config,
        \April\Payments\Helper\Generic $helper
    ) {
        $this->config = $config;
        $this->helper = $helper;
        $this->customer = $helper->getCustomerModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig()
    {
        if ($this->getStoreConfigValue('active')) {
            $aprilpaymentsConfig = array();
            $aprilpaymentsConfig['instructions'] = array();
            $aprilpaymentsConfig['instructions']['aprilpayments'] = $this->getStoreConfigValue('instructions');
            $aprilpaymentsConfig['instructions']['aprilpayments_payplan'] = $this->getStoreConfigValue('instructions', 'aprilpayments_payplan');
            $aprilpaymentsConfig['instructions']['aprilpayments_paycard'] = $this->getStoreConfigValue('instructions', 'aprilpayments_paycard');

            $aprilpaymentsConfig['titleSetting'] = array();
            $aprilpaymentsConfig['titleSetting']['aprilpayments'] = $this->getStoreConfigValue('title_setting');
            $aprilpaymentsConfig['titleSetting']['aprilpayments_payplan'] = $this->getStoreConfigValue('title_setting', 'aprilpayments_payplan');
            $aprilpaymentsConfig['titleSetting']['aprilpayments_paycard'] = $this->getStoreConfigValue('title_setting', 'aprilpayments_paycard');

            $aprilpaymentsConfig['publishablekey'] = $this->getStoreConfigValue('publishablekey');
            $aprilpaymentsConfig['defaultPaymentMethod'] = $this->getStoreConfigValue('default_payment_method');
            $aprilpaymentsConfig['availablePaymentOption'] = $this->getStoreConfigValue('available_payment_options');
            $aprilpaymentsConfig['individualPaymentOption'] = $this->getStoreConfigValue('individual_payment_options');
            $aprilpaymentsConfig['preventWalletSubmit'] = !($this->getStoreConfigValue('wallet_payments_place_order'));
            $aprilpaymentsConfig['saveCardInCheckout'] = !($this->getStoreConfigValue('save_card_in_checkout'));
            $aprilpaymentsConfig['selectedPaymentOption'] = $this->getSelectedPaymentOption();
            $aprilpaymentsConfig['primaryColor'] = $this->getStoreConfigValue('primary_color');
            $aprilpaymentsConfig['isLoggedIn'] = $this->helper->isCustomerLoggedIn();
            $aprilpaymentsConfig['customToken'] = $this->getAprilCustomToken();

            $config = [
                'payment' => [
                    'aprilpayments' => $aprilpaymentsConfig
                ]
            ];

            return $config;
        } else {
            return [];
        }
    }

    public function getStoreConfigValue($fieldId, $code = 'aprilpayments')
    {
        return $this->config->getConfigData($code, $fieldId);
    }

    private function getAprilCustomToken()
    {
        try {
            if ($this->getStoreConfigValue('save_card_in_checkout') == 1 && $this->helper->isCustomerLoggedIn()) {
                return $this->customer->signInCustomer();
            }
            return null;
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            return null;
        } catch (\Exception $e) {
            return null;
        }
    }

    private function getSelectedPaymentOption()
    {
        $selectedPaymentOption = 'aprilpayments';

        $indivPayOptions = $this->getStoreConfigValue('individual_payment_options');
        if ($indivPayOptions == 1) {
            $availPayOptions = $this->getStoreConfigValue('available_payment_options');
            if ($availPayOptions == 'payplan') {
                $selectedPaymentOption = 'aprilpayments_payplan';
            } else if ($availPayOptions == 'paycard') {
                $selectedPaymentOption = 'aprilpayments_paycard';
            } else {
                $sortOrderPayplan = $this->getStoreConfigValue('sort_order', 'aprilpayments_payplan');
                $sortOrderPaycard = $this->getStoreConfigValue('sort_order', 'aprilpayments_paycard');

                if ($sortOrderPaycard < $sortOrderPayplan) {
                    $selectedPaymentOption = 'aprilpayments_paycard';
                } else {
                    $selectedPaymentOption = 'aprilpayments_payplan';
                }
            }
        }

        return $selectedPaymentOption;
    }
}
