<?php
namespace April\Payments\Model;

use April\Payments\Helper\Logger;

class ThreeDSAuthorisation
{
    public $_threeDSAuthorisation;

    protected $_paymentMethodCode;
    protected $session;

    const SESSION_3DS_AUTHORISATION_PARAM_NAME = 'saved_3ds_authorisation';

    public function __construct(
        \Magento\Framework\Session\Generic $session
    ) {
        $this->session = $session;
    }

    public function init( $paymentMethodCode )
    {
        $this->_paymentMethodCode = $paymentMethodCode;
    }

    public function process( $threeDSAuthorisation )
    {
        $this->validate($threeDSAuthorisation);
        $this->_threeDSAuthorisation = $threeDSAuthorisation;
    }

    public function setThreeDSAuthorisation( $threeDSAuthorisation )
    {
        $this->_threeDSAuthorisation = $threeDSAuthorisation;
        $this->session->setData( $this->getSessionParamName(), json_encode( $threeDSAuthorisation ) );
    }

    public function isThreeDSAuthorisationRequired()
    {
        return ( isset( $this->_threeDSAuthorisation ) && !empty( $this->_threeDSAuthorisation ) );
    }

    private function validate( $threeDSAuthorisation )
    {
        $savedThreeDSAuthorisation = $this->fetchSavedThreeDSAuthorisation();
        if ( isset( $savedThreeDSAuthorisation ) && !empty( $savedThreeDSAuthorisation ) ) {
            if ( $savedThreeDSAuthorisation == $threeDSAuthorisation ) {
                return true;
            }
        }
        $errorMsg = 'April 3DS Authorisation data validation failed:';
        \April\Payments\Helper\Logger::warning( $errorMsg );
        throw new \Magento\Framework\Exception\LocalizedException( __( $errorMsg ) );
    }

    private function fetchSavedThreeDSAuthorisation()
    {
        $savedThreeDSAuthorisation = $this->session->getData( $this->getSessionParamName() );
        if ( isset( $savedThreeDSAuthorisation ) && !empty( $savedThreeDSAuthorisation ) ) {
            return json_decode( $savedThreeDSAuthorisation );
        }
        return null;
    }

    private function getSessionParamName( $paymentMethodCode = null )
    {
        $pMCode = $this->_paymentMethodCode;
        if ( isset( $paymentMethodCode ) ) {
            $pMCode = $paymentMethodCode;
        }
        return ThreeDSAuthorisation::SESSION_3DS_AUTHORISATION_PARAM_NAME . '_' . $pMCode;
    }

    public function clearThreeDSAuthorisation()
    {
        $this->session->setData( $this->getSessionParamName('aprilpayments'), null );
        $this->session->setData( $this->getSessionParamName('aprilpayments_paycard'), null );
        $this->session->setData( $this->getSessionParamName('aprilpayments_payplan'), null );
        $this->_threeDSAuthorisation = null;
    }
}
