<?php

namespace April\Payments\Plugin\Model\Service;

class OrderService
{
    protected $helper;

    public function __construct(
        \April\Payments\Helper\Generic $helper
    ) {
        $this->helper = $helper;
    }

    public function aroundPlace($subject, \Closure $proceed, $order)
    {
        try {
            $processedOrder = $proceed($order);
            return $processedOrder;
        }
        catch (\Exception $e) {
            $msg = $e->getMessage();

            if ($this->helper->isPaymentActionRequiredMessage($msg)) {
                throw $e;
            } else {
                throw new \Magento\Framework\Exception\CouldNotSaveException(__($msg), $e);
            }
        }
    }
}