// Copyright © April
//
// @package    April_Payments
// @version    1.0.9

var newAprilCheckout = function(params, callback)
{
    if (typeof callback == "undefined")
        callback = null;

    require(['aprilpaymentsjs'], function(aprilpaymentsjs)
    {
        april.initAprilCheckoutJs(params, callback);
    });
};

var april =
{
  version: "1.0.9",
  checkout: {},
  adminCheckout: null,

  initAprilCheckoutJs: function(params, callback)
  {
      var instanceId = params.instanceId;
      var isAdmin = params.isAdmin;
      var message = null;

      try
      {
          if (typeof instanceId == "undefined" || instanceId == null) {
            throw {message: 'Missing instanceId'};
          }
          if (params.isAdmin && !april.adminCheckout) {
            april.adminCheckout = window.AprilCheckout.createCheckout();
          } else if (!(instanceId in april.checkout)) {
            april.checkout[instanceId] = window.AprilCheckout.createCheckout();
          }
      }
      catch (e)
      {
          if (typeof e != "undefined" && typeof e.message != "undefined")
              message = 'Could not create AprilCheckout: ' + e.message;
          else
            message = 'Could not create AprilCheckout';
      }

      if (callback)
          callback(message);
      else
          console.log(message);
  },

  getAprilCheckout: function(instanceId) {
    return april.checkout[instanceId];
  },

  isThreeDSAuthorisationRequired: function( message ) {
     var payActParams = message.split('::');
     return ( payActParams.length > 0 && payActParams[0] == '3DS Authorisation required' );
  },

  initAdminCheckout: function()
  {
      if (typeof order != "undefined" && typeof order._submit != "undefined")
      {
          return;
      }
      else if (typeof order != "undefined" && typeof order._submit == "undefined")
      {
          order._submit = order.submit;
          order.submit = april.adminPlaceOrder;
      }
      april.adminCheckout = window.AprilCheckout.createCheckout();
  },

  renderAdminCheckout: function (elementId, params)
  {
      if (!april.adminCheckout) {
          alert('April admin checkout not initialised.');
          return;
      }

      var hidePayLaterOption = false;
      var hideFullPayOption = false;

      if (params.availablePaymentOption === "paycard") {
          hidePayLaterOption = true;
      } else if (params.availablePaymentOption === "payplan") {
          hideFullPayOption = true;
      }

      var initParams = {
          publicKey: params.publishableKey,
          preventWalletSubmit: true,
          email: params.email,
          customerFirstName: params.firstName,
          customerMiddleName: params.middleName,
          customerLastName: params.lastName,
          customerResidentialAddress: params.address,
          phone: params.phoneNumber,
          hidePayLaterOption: hidePayLaterOption,
          hideFullPayOption: hideFullPayOption,
          paymentToken: april.handleAdminCheckoutPaymentToken.bind(april),
          platform: 'magento',
          platformVersion: '2',
          platformPluginVersion: april.version
      };

      var renderParams = {
         elementId: elementId,
         currency: params.currency,
         amount: params.amount,
         paymentType: 'paycard',
         showPayNow: false,
         showPayPlanSubmit: false,
      };

      april.adminCheckout.init(initParams);
      april.adminCheckout.render(renderParams);
  },

  handleAdminCheckoutPaymentToken: function (paymentToken) {
      document.getElementById('april-payment-token').value = paymentToken;
      order._submit();
  },

  adminPlaceOrder: function() {
      if (order.paymentMethod === 'aprilpayments') {
          april.adminCheckout.submit();
      }else {
          order._submit();
      }
  }

}
