<?php
namespace April\Payments\Helper;

use Psr\Log\LoggerInterface;

class Logger
{
    static $logger = null;

    public static function getPrintableObject($obj)
    {
        if (!Logger::$logger)
            Logger::$logger = \Magento\Framework\App\ObjectManager::getInstance()->get(\Psr\Log\LoggerInterface::class);

        if (is_object($obj))
        {
            if (method_exists($obj, 'debug'))
                $data = $obj->debug();
            else if (method_exists($obj, 'getData'))
                $data = $obj->getData();
            else
                $data = $obj;
        }
        else if (is_array($obj)) {
            try {
                $data = 'April ' . json_encode($obj);
            }
            catch (\Exception $e)
            {
                $data = print_r($obj, true);
            }
        } else
            $data = $obj;

        return $data;
    }

    public static function debug($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addDebug'))
                Logger::$logger->addDebug($data);
            else
                Logger::$logger->debug($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function info($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addInfo'))
                Logger::$logger->addInfo($data);
            else
                Logger::$logger->info($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function notice($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addNotice'))
                Logger::$logger->addNotice($data);
            else
                Logger::$logger->notice($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function warning($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addWarning'))
                Logger::$logger->addWarning($data);
            else
                Logger::$logger->warning($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function error($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addError'))
                Logger::$logger->addError($data);
            else
                Logger::$logger->error($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function critical($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addCritical'))
                Logger::$logger->addCritical($data);
            else
                Logger::$logger->critical($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function alert($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addAlert'))
                Logger::$logger->addAlert($data);
            else
                Logger::$logger->alert($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }

    public static function log($obj)
    {
        try
        {
            $data = Logger::getPrintableObject($obj);

            if (method_exists(Logger::$logger, 'addInfo'))
                Logger::$logger->addInfo($data);
            else
                Logger::$logger->error($data); // M2.4.2 and newer
        }
        catch (\Exception $e)
        {
            // Cannot log error
        }
    }
}
