<?php
namespace April\Payments\Model;

use April\Payments\Helper\Logger;
use April\Payments\Helper\Generic;
use April\Payments\Model\Config;

class Customer
{
    protected $api;
    protected $helper;
    protected $config;
    protected $customerCollection;
    
    public function __construct(
        \April\Payments\Helper\Api $api,
        \April\Payments\Helper\Generic $helper,
        \April\Payments\Model\Config $config,
        \April\Payments\Model\ResourceModel\AprilCustomer\Collection $customerCollection
    ) {
        $this->api            = $api;
        $this->helper         = $helper;
        $this->config         = $config;
        $this->customerCollection = $customerCollection;
    }

    public function create( $customerData )
    {
        $customerParams = [
            'internalCustomerId' => $customerData['customerId'],
            'emailAddress' => $customerData['emailAddress']
        ];
        $customerResp = $this->api->upsertCustomer( $customerParams );

        $this->helper->isHttpSuccess($customerResp, 'Failed to upsert April customer');
        return $customerResp['data']['customerId'];
    }

    public function signin( $customerId )
    {
        $customerParams = [
            'customerId' => $customerId
        ];
        $customerResp = $this->api->signInCustomer( $customerParams );

        $this->helper->isHttpSuccess($customerResp, 'Failed to upsert April customer');
        return $customerResp['data'];
    }

}
