define([
    'jquery',
    'jquery/jquery.cookie'
], function ($) {

    $.widget('april.installmentToggle', {
        /**
         * This method constructs a new widget.
         * @private
         */
        _create: function () {
            var self = this;

            /* Trigger checkbox on click of whole area */
            $(document).on('click', '.april-toggle-container', function(e) {
                var toggleElem = $(this).find('input[type="checkbox"]');
                toggleElem.prop('checked', !toggleElem.prop("checked"));
                self._toggleChange(toggleElem);
            });
        },

        _toggleChange: function(toggleElem) {
            var self = this;
            var minAmtLimit = parseFloat(self._accessCookie('minAllowedAmt'));

            if (toggleElem.closest('.april-toggle-container').hasClass('payplan-disabled')) {
                toggleElem.prop('checked', false);
                var parentLabelElem = toggleElem.closest('.switch');
                parentLabelElem.addClass("disabled-swt");
                // Reset Toggle Animations;
                setTimeout(function() {
                    parentLabelElem.removeClass("disabled-swt");
                }, 610);
                // Add popover;
                if ($(".april-popover").length == 0) {
                    $(".april-toggle-container").after('<div class="april-popover-bottom april-popover"><div class="arrow"></div><div class="popover-body">Split the cost over 4 payments when you spend $' + minAmtLimit +' or more</div></div>');
                }
                return false;
            }
            
            
            if (toggleElem.prop('checked')) {
                self._createCookie('aprilInstallmentToken', '1', 120); /* Set cookie for 2 hours */
                $('.april-toggle-container .payment-type').removeClass('active');
                $('.april-toggle-container .payment-type.april-split-payment').addClass('active');
                $('.april-installment-offer__shortcode .april-installment-price').addClass('active');
            } else {
                self._deleteCookie('aprilInstallmentToken');
                $('.april-toggle-container .payment-type').removeClass('active');
                $('.april-installment-offer__shortcode .april-installment-price').removeClass('active')
                $('.april-toggle-container .payment-type.april-one-time').addClass('active');
            }
        },

        _createCookie: function (cookieName, value, minutes) {
            var date = new Date();
            date.setTime(date.getTime() + (minutes * 60 * 1000));
        
            $.cookie(cookieName, value, {expires: date});
        },

        _accessCookie: function (cookieName) {
            return $.cookie(cookieName);
        },

        _deleteCookie: function (cookieName) {
            $.cookie(cookieName, '', {path: '/', expires: -1});
        }
    });

    return $.april.installmentToggle;
});
