<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilPaymentAction
{
    const APRIL_PA_SESSION_VAR_NAME = 'aprilPaymentActionData';

    public $paymentActionRequired;
    public $amount;
    public $currency;
    public $aprilOrderId;
    public $paymentToken;
    public $request3DS;

    public function retrieve()
    {
        if ( isset($_SESSION[self::APRIL_PA_SESSION_VAR_NAME]) ) {
            $aprilPaymentActionData = json_decode($_SESSION[self::APRIL_PA_SESSION_VAR_NAME]);
            PrestaShopLogger::addLog(
                'Retrieving payment action data: ' . (string) json_encode($aprilPaymentActionData),
                1,
                AprilHelper::E_CODE_PAYMENT_ACTION_RETRIEVED_SESSION,
                'AprilPaymentAction',
                1
            );
            $this->setPaymentActionRequired( $aprilPaymentActionData->paymentActionRequired );
            $this->setAmount( $aprilPaymentActionData->amount, $aprilPaymentActionData->currency );
            $this->setAprilOrderId( $aprilPaymentActionData->aprilOrderId );
            $this->setPaymentToken( $aprilPaymentActionData->paymentToken );
            $this->setRequest3DS( $aprilPaymentActionData->request3DS );
        }
    }

    public function setPaymentActionRequired( $paymentActionRequired )
    {
        $this->paymentActionRequired = $paymentActionRequired;
    }

    public function setAmount( $amount, $currency )
    {
        $this->amount = $amount;
        $this->currency = $currency;
    }

    public function setAprilOrderId( $aprilOrderId )
    {
        $this->aprilOrderId = $aprilOrderId;
    }

    public function setPaymentToken( $paymentToken )
    {
        $this->paymentToken = $paymentToken;
    }

    public function setRequest3DS( $request3DS )
    {
        $this->request3DS = $request3DS;
    }

    public function isPaymentActionRequired()
    {
        return !is_null( $this->paymentActionRequired );
    }

    public function reset()
    {
        PrestaShopLogger::addLog(
            'Reset payment action data',
            1,
            AprilHelper::E_CODE_PAYMENT_ACTION_RESET_SESSION,
            'AprilPaymentAction',
            1
        );
        unset($_SESSION[self::APRIL_PA_SESSION_VAR_NAME]);
        $this->paymentActionRequired = null;
        $this->amount = null;
        $this->currency = null;
        $this->aprilOrderId = null;
        $this->paymentToken = null;
        $this->request3DS = null;
    }

    public function save()
    {
        $aprilPaymentActionData = [
            'paymentActionRequired' => $this->paymentActionRequired,
            'amount' => $this->amount,
            'currency' => $this->currency,
            'aprilOrderId' => $this->aprilOrderId,
            'paymentToken' => $this->paymentToken,
            'request3DS' => $this->request3DS
        ];

        $_SESSION[self::APRIL_PA_SESSION_VAR_NAME] = json_encode($aprilPaymentActionData);
        PrestaShopLogger::addLog(
            json_encode( $aprilPaymentActionData ),
            1,
            AprilHelper::E_CODE_PAYMENT_ACTION_SAVED_SESSION,
            'AprilPaymentAction',
            1
        );
    }
}
