<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilPaymentToken
{
    public $paymentTokenId = null;
    public $method = null;

    private $aprilApi;

    public function __construct()
    {
        $this->aprilApi = new AprilApi( Configuration::get( 'APRIL_SECRET_API_KEY' ) );
    }

    public function fetch( $paymentTokenId ) {

        $this->paymentTokenId = $paymentTokenId;

        $resp = $this->aprilApi->queryPaymentToken( $this->paymentTokenId );

        if ( $resp->isSuccess() ) {
            $this->method = $resp->getData( 'method' );
        }
        else {
            $message = AprilHelper::getApiErrorMessage( $resp );
            $message = empty( $message ) ? 'Failed to fetch payment token data' : $message;

            PrestaShopLogger::addLog(
                'Payment failed: ' . $message,
                1,
                AprilHelper::E_CODE_APRIL_FAILED_TO_FETCH_PAYMENT_TOKEN_DATA,
                'AprilPaymentToken',
                1
            );
            throw new Exception( $message );
        }
    }
}
