<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilRedirectModuleFrontController extends AprilAbstractModuleFrontController
{
    public function processPayment()
    {
        session_start();
        PrestaShopLogger::addLog(
            'Begin post redirect payment process',
            1,
            AprilHelper::E_CODE_REDIRECT_PAYMENT_PROCESS,
            'AprilRedirectController',
            1
        );

        $aprilPaymentAction = new AprilPaymentAction();
        $aprilPaymentAction->retrieve();

        $orderCurrency = $this->getOrderCurrency();
        $orderTotal = $this->getOrderGrandTotal();

        if ( $aprilPaymentAction->isPaymentActionRequired() ) {
            $aprilTransaction = new AprilTransaction();
            // $aprilPaymentAction will get reset in the $aprilTransaction->create() call.
            // Save the aprilOrderId value to a variable to be used to complete the order - 07/05/2025.
            $aprilOrderId = $aprilPaymentAction->aprilOrderId;

            $aprilTransaction->create(
                $aprilPaymentAction->aprilOrderId,
                $orderTotal,
                $orderCurrency->iso_code,
                $aprilPaymentAction->paymentToken,
                null,
                $aprilPaymentAction,
                $aprilPaymentAction->request3DS,
                $aprilPaymentAction->paymentActionRequired
            );

            $this->completeOrder( $aprilTransaction->transactionId, $aprilOrderId );
            $aprilPaymentAction->reset();

        } else {
            PrestaShopLogger::addLog(
                'Payment action data not found',
                3,
                AprilHelper::E_CODE_PAYMENT_ACTION_DATA_NOT_FOUND,
                'AprilRedirectController',
                1
            );
            $aprilPaymentAction->reset();
            throw new Exception( 'Payment session expired or invalid.' );
        }
    }

    protected function additionalValidations()
    {
        return true;
    }
}
