"use strict";

(function($) {
  var aprilCheckout;
  var aprilPlaceHolderId = 'april-checkout-cont';
  var aprilInProgress = false;

  var aprilCheckoutElem = document.getElementById('april-checkout');
  if (!aprilCheckoutElem) {
    return;
  }
  var aprilCheckoutConfig = JSON.parse( aprilCheckoutElem.dataset.aprilCheckoutConfig );
  var placeOrderButton = $('#checkout #checkout-payment-step .ps-shown-by-js button');
  var placeOrderButtonOrgText = placeOrderButton.text();
  var aprilCheckoutOptionForm = $(aprilCheckoutElem).parents('.additional-information').next().find('form').first();

  var setPaymentTokenAndDataElementValues = function(paymentToken, paymentData) {
    var paymentTokenElm = aprilCheckoutOptionForm.find('input[name="april-payment-token"]').first();
    var paymentDataElm = aprilCheckoutOptionForm.find('input[name="april-payment-data"]').first();
    if (paymentTokenElm.length === 0) {
      aprilCheckoutOptionForm.prepend('<input type="hidden" name="april-payment-token" value="" />');
      paymentTokenElm = aprilCheckoutOptionForm.find('input[name="april-payment-token"]').first();
    }
    if (paymentDataElm.length === 0) {
      aprilCheckoutOptionForm.prepend('<input type="hidden" name="april-payment-data" value="" />');
      paymentDataElm = aprilCheckoutOptionForm.find('input[name="april-payment-data"]').first();
    }
    paymentTokenElm.val(paymentToken);
    paymentDataElm.val(JSON.stringify(paymentData));
  };

  var handlePaymentToken = function(paymentToken, paymentData) {
    setPaymentTokenAndDataElementValues(paymentToken, paymentData);
    aprilCheckoutOptionForm.submit();
  };

  var scrollIntoViewApril = function() {};

  var resetPlaceOrderButton = function() {
    aprilInProgress = false;
    placeOrderButton.text(placeOrderButtonOrgText);
  };

  var limepyCheckoutErrorHandler = function() {
    scrollIntoViewApril();
    resetPlaceOrderButton();
  };

  var aprilCheckoutEventHandler = function(lpEvent) {
    if (lpEvent.eventName == 'april_card_3DS_pending') {
      scrollIntoViewApril();
      resetPlaceOrderButton();
    }
  };

  var renderAprilCheckout = function() {

    // var payOptions = self.showHideOptions();
    var address = aprilCheckoutConfig.address;

    var initParams = {
      publicKey: aprilCheckoutConfig.publishablekey,
      email: aprilCheckoutConfig.email,
      customerFirstName: address.firstname,
      customerLastName: address.lastname,
      customerResidentialAddress: getResidentialAddress(address),
      phone: address.telephone,
      hidePayLaterOption: false,
      hideFullPayOption: false,
      preventWalletSubmit: aprilCheckoutConfig.preventwalletsubmit,
      paymentToken: handlePaymentToken,
      platform: 'prestashop',
      platformVersion: '1.7',
      platformPluginVersion: april.version
    };

    if (aprilCheckoutConfig.customertoken) {
      initParams.customerToken = aprilCheckoutConfig.customertoken;
    }

    var renderParams = {
      elementId: aprilPlaceHolderId,
      currency: aprilCheckoutConfig.currency,
      amount: aprilCheckoutConfig.amount,
      // paymentType: self.isPayplanOptionPreselected() ? 'payplan' : 'paycard',
      showPayNow: false,
      showPayPlanSubmit: false,
    };

    if (aprilCheckoutConfig.primarycolor) {
      renderParams.primaryColor = aprilCheckoutConfig.primarycolor;
    }

    aprilCheckout.init(initParams);
    aprilCheckout.render(renderParams);
  }

  var getResidentialAddress = function(address) {
    var residAddress = (address.street ? address.street + ' ' : '');
    residAddress += (address.city ? address.city + ' ' : '');
    residAddress += (address.region ? address.region + ' ' : '');
    residAddress += (address.postcode ? address.postcode + ' ' : '');
    residAddress += (address.countryId ? address.countryId : '');

    return residAddress;
  }

  var overridePlaceOrder = function() {
    placeOrderButton.click((e) => {
      if ($('input[type="radio"][data-module-name="april"]').prop('checked')){
        e.preventDefault();
        e.stopPropagation();
        if (placeOrderButton.hasClass( "disabled" ) === false && !aprilInProgress){
          aprilInProgress = true;
          aprilCheckout.submit();
          placeOrderButton.text('Processing...');
        };
      }
    });
  };

  var params = {
    instanceId: aprilPlaceHolderId
  };

  newAprilCheckout(params, function(err) {
    if (err) {
        console.log(err);
        return;
    }
    aprilCheckout = april.getAprilCheckout( aprilPlaceHolderId );
    renderAprilCheckout();
    aprilCheckout.errorHandler(limepyCheckoutErrorHandler);
    aprilCheckout.eventHandler(aprilCheckoutEventHandler);
    overridePlaceOrder();
  });

})(jQuery);
