<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilCustomer extends ObjectModel
{
    /** @var int */
    public $id_customer;
    /** @var string */
    public $april_customer_id;
    /** @var string */
    public $april_merchant_id;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'april_customer',
        'primary' => 'id_april_customer',
        'fields' => [
            'id_customer' => [
                'type' => ObjectModel::TYPE_INT,
                'validate' => 'isInt',
                'size' => 10,
            ],
            'april_customer_id' => [
                'type' => ObjectModel::TYPE_STRING,
                'validate' => 'isString',
                'size' => 50,
            ],
            'april_merchant_id' => [
                'type' => ObjectModel::TYPE_STRING,
                'validate' => 'isString',
                'size' => 50,
            ],
        ],
    ];

    public function getCustomerById($id_customer, $april_merchant_id)
    {
        $query = new DbQuery();
        $query->select('*');
        $query->from(static::$definition['table']);
        $query->where('id_customer = ' . (int) $id_customer);
        $query->where('april_merchant_id = "' . pSQL($april_merchant_id) . '"');

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query->build());
        if (empty($result) === true) {
            return $this;
        }

        $this->hydrate($result);

        return $this;
    }
}
