<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilApiResponse
{
    private $success = false;
    private $httpStatusCode;
    private $data = [];
    private $errorData = [];

    public function __construct( $httpStatusCode = null, $data = [], $errorData = [] )
    {
        $this->httpStatusCode = (int) $httpStatusCode;
        $this->data = $data;
        $this->errorData = $errorData;

        $this->setSuccess();
    }

    private function setSuccess()
    {
        $this->success = ( $this->httpStatusCode >= 200 && $this->httpStatusCode < 300 );
    }

    public function isSuccess()
    {
        return $this->success;
    }

    public function getErrorDetail()
    {
        if ( isset( $this->errorData['detail'] ) ) {
            return $this->errorData['detail'];
        }
        return null;
    }

    public function getErrorMessage()
    {
        if ( isset( $this->errorData['message'] ) ) {
            return $this->errorData['message'];
        }
        return null;
    }

    public function getErrorCode()
    {
        if ( isset( $this->errorData['errorCode'] ) ) {
            return $this->errorData['errorCode'];
        }
        return null;
    }

    public function getTracer()
    {
        if ( isset( $this->errorData['tracer'] ) ) {
            return $this->errorData['tracer'];
        }
        return 'Not available';
    }

    public function getData( $key = null )
    {
        if ( is_null( $key ) ) {
            return $this->data;
        } else {
            if ( array_key_exists( $key, $this->data ) ) {
                return $this->data[$key];
            }
            return null;
        }
    }

    public function getErrorData()
    {
        return $this->errorData;
    }

    public function isHttpStatusCode( $statusCode )
    {
        return ( $this->httpStatusCode === (int) $statusCode );
    }

    public function isNotHttpStatusCode( $statusCode )
    {
        return ( $this->httpStatusCode !== (int) $statusCode );
    }
}
