<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilHelper
{
    const E_CODE_INTL_ORDER_UPDATE_FAILED = 1;
    const E_CODE_APRIL_ORDER_CREATION_FAILED = 2;
    const E_CODE_PAYMENT_ACTION_RETRIEVED_SESSION = 3;
    const E_CODE_PAYMENT_ACTION_SAVED_SESSION = 4;
    const E_CODE_PAYMENT_ACTION_RESET_SESSION = 5;
    const E_CODE_3DS_REDIRECTION_REQUIRED = 6;
    const E_CODE_APRIL_FAILED_PAYMENT = 7;
    const E_CODE_APRIL_SUCCESS_PAYMENT = 8;
    const E_CODE_API_REQUEST_FAILED = 9;
    const E_CODE_API_SUCCESS_RESPONSE = 10;
    const E_CODE_API_REQUEST = 11;
    const E_CODE_URL_REDIRECT = 12;
    const E_CODE_PAYMENT_PROCESS_FAILED = 13;
    const E_CODE_REDIRECT_PAYMENT_PROCESS = 14;
    const E_CODE_PAYMENT_PROCESS = 15;
    const E_CODE_PAYMENT_ACTION_DATA_NOT_FOUND = 16;
    const E_CODE_PARTIAL_REFUND = 17;
    const E_CODE_FULL_REFUND = 18;
    const E_CODE_APRIL_CUSTOMER_UPSERT_FAILED = 19;
    const E_CODE_APRIL_CUSTOMER_SIGNIN_FAILED = 20;
    const E_CODE_APRIL_FAILED_TO_FETCH_PAYMENT_TOKEN_DATA = 21;

    public static function convertToCents( $amount )
    {
        return round( $amount * 100 );
    }

    public static function getApiErrorMessage( $apiResp )
    {
        $apiErrorCode = $apiResp->getErrorCode();
        $apiMessage = $apiResp->getErrorMessage();
        $apiDetail = $apiResp->getErrorDetail();
        $apiTracer = $apiResp->getTracer();
    
        $errorList = array(
            'do_not_honor'          => 'Please contact your card issuer',
            'expired_card'          => 'Card expired',
            'fraudulent'            => 'Suspected fraudulent transaction',
            'incorrect_cvc'         => 'Incorrect CVC',
            'insufficient_funds'    => 'Insufficient funds',
            'invalid_cvc'           => 'Invalid CVC',
            'invalid_expiry_month'  => 'Invalid expiry month',
            'invalid_expiry_year'   => 'Invalid expiry year',
            'pickup_card'           => 'Card not allowed',
            'stolen_card'           => 'Card is reported stolen'
        );
        if ( isset( $apiErrorCode ) && array_key_exists( $apiErrorCode, $errorList ) ) {
            return $errorList[$apiErrorCode];
        }
        return (!empty( $apiMessage ) ? $apiMessage : '') . (!empty( $apiErrorCode ) ? ' [' . $apiErrorCode . '] ' : '') . (!empty( $apiDetail ) ? $apiDetail : '') . ' [Error reference: ' . $apiTracer . ']';
      }
}
