<?php
/**
 * Copyright © April Solutions.
 * This file is part of April payments module for PrestaShop.
 *
 * @author    April Solutions (https://www.meetapril.com/)
 * @copyright April Solutions
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class AprilPluginCustomer
{
    public $customerId;
    public $internalCustomerId = '';
    public $firstName = '';
    public $lastName = '';
    public $email = '';

    private $aprilApi;

    public function __construct()
    {
        $this->aprilApi = new AprilApi( Configuration::get( 'APRIL_SECRET_API_KEY' ) );
    }

    public function create()
    {
        $customerData = [
            'RegisterPluginConsumerCustomer' => [
                'referenceCustomerId' => (string) $this->internalCustomerId,
                'givenName' => $this->firstName,
                'familyName' => $this->lastName,
                'emailAddress' => $this->email
            ]
        ];

        $resp = $this->aprilApi->upsertCustomer( $customerData );

        if( !$resp->isSuccess() ) {
            PrestaShopLogger::addLog(
                json_encode( $resp->getErrorData() ),
                3,
                AprilHelper::E_CODE_APRIL_CUSTOMER_UPSERT_FAILED,
                'AprilPluginCustomer',
                1
            );
        } else {
            $this->customerId = $resp->getData()['customerId'];
        }
    }

    public function signInCustomer( $customerId )
    {
        $args = [
            'SignInConsumer' => [
				'customerId' => $customerId
			]
        ];
        $resp = $this->aprilApi->signInCustomer( $args );

        if( !$resp->isSuccess() ) {
            PrestaShopLogger::addLog(
                json_encode( $resp->getErrorData() ),
                3,
                AprilHelper::E_CODE_APRIL_CUSTOMER_SIGNIN_FAILED,
                'AprilPluginCustomer',
                1
            );
            return null;
        } 
        return $resp->getData()['customToken'];
    }
}
