// Copyright © April
//
// @version    1.0.2

var newAprilCheckout = function(params, callback)
{
    if (typeof callback == "undefined")
        callback = null;

    if (AprilCheckout) {
        april.initAprilCheckoutJs(params, callback);
    };
};

var april =
{
  version: "1.0.2",
  checkout: {},
  adminCheckout: null,

  initAprilCheckoutJs: function(params, callback)
  {
      var instanceId = params.instanceId;
      var isAdmin = params.isAdmin;
      var message = null;

      try
      {
          if (typeof instanceId == "undefined" || instanceId == null) {
            throw {message: 'Missing instanceId'};
          }
          if (params.isAdmin && !april.adminCheckout) {
            april.adminCheckout = AprilCheckout.createCheckout();
          } else if (!(instanceId in april.checkout)) {
            april.checkout[instanceId] = AprilCheckout.createCheckout();
          }
      }
      catch (e)
      {
          if (typeof e != "undefined" && typeof e.message != "undefined")
              message = 'Could not create AprilCheckout: ' + e.message;
          else
            message = 'Could not create AprilCheckout';
      }

      if (callback)
          callback(message);
      else
          console.log(message);
  },

  getAprilCheckout: function(instanceId) {
    return april.checkout[instanceId];
  }
}
