'use strict';

/**
 * Signin Limepay customer with Customer ID
 * @param {String} customerId - Limepay customer ID
 * @returns {Object} - Limepay create upsert customer response
 */
exports.signInLimepayCustomerWithCustomerId = function (customerId) {
    var ServiceBuilder = require('~/cartridge/scripts/common/limepayServiceBuilder');
    var APIContextLib = require('~/cartridge/scripts/common/limepayAPIContext');
    var LimepayService = require('~/cartridge/scripts/services/limepayService');
    var CommonUtils = require('*/cartridge/scripts/common/limepayCommonUtils');

    var clientSecretKey = ServiceBuilder.getClientSecretKey();
    var limepayAPIContext = new APIContextLib();
    var url = limepayAPIContext.getLimepayAPIUrls().get('signInCustomerWithCustomerId');

    var callArgs = {
        secretKey: clientSecretKey,
        urlPath: url,
        type: 'Sign In Customer With Customer Id'
    };

    var requestBody = {
        customerId: customerId
    };
    var response = LimepayService.call(callArgs, requestBody);

    if (response.ok && response.object) {
        CommonUtils.logDebug('Customer Signed Limepay with ID : ' + customerId);
    } else {
        CommonUtils.logError('Error on Signin Customer');
    }

    return response;
};
