'use strict';

/**
 * Upserts a Limepay customer
 * @param {dw.customer.CustomerMgr} customer - SFCC customer
 * @returns {Object} - Limepay create upsert customer response
 */
exports.upsertLimepayCustomer = function (customer) {
    var ServiceBuilder = require('~/cartridge/scripts/common/limepayServiceBuilder');
    var APIContextLib = require('~/cartridge/scripts/common/limepayAPIContext');
    var LimepayService = require('~/cartridge/scripts/services/limepayService');
    var CommonUtils = require('*/cartridge/scripts/common/limepayCommonUtils');
    var Transaction = require('dw/system/Transaction');

    var clientSecretKey = ServiceBuilder.getClientSecretKey();
    var limepayAPIContext = new APIContextLib();
    var url = limepayAPIContext.getLimepayAPIUrls().get('upsertCustomer');

    var callArgs = {
        secretKey: clientSecretKey,
        urlPath: url,
        type: 'Upsert Customer'
    };

    var requestBody = ServiceBuilder.getUpsertCustomerRequestBody(customer);
    var response = LimepayService.call(callArgs, requestBody);

    if (response.ok && response.object) {
        CommonUtils.logDebug('Customer upserted at Limepay with ID : ' + response.object.customerId);
        Transaction.wrap(function () {
            customer.profile.custom.limepayCustomerId = response.object.customerId;
        });
    } else {
        CommonUtils.logError('Error on Upserting Customer');
    }

    return response;
};
