'use strict';
var base = require('base/product/detail');

base.limepayUpdateAttribute = function () {
    $('body').on('product:afterAttributeSelect', function (e, response) {
        // Update Limepay widget
        var limepayProductData = response.data.product.limepayProductData;
        // Textual widget price update
        if ($('.limepay-textual').length > 0) {
            response.container.find('.limepay-textual span.installment-value').html(limepayProductData.installment.toFixed(2));
        } else if ($('.limepay-option').length > 0) {
            // Toggle widget price update
            response.container.find('.limepay-option .limepay-pay-onetime span.value').html(limepayProductData.amount.toFixed(2));
            response.container.find('.limepay-option .limepay-payin-four span.value').html(limepayProductData.installment.toFixed(2));
            var userToggleURL = $('.limepay-switch input[name=limepay-selection]').data('usertoggleurl');
            $.ajax({
                url: userToggleURL,
                success: function (data) {
                    // Update Limepay toogle widget state with real time user value
                    var userTogglePreselection = data.togglePreselection;
                    $('.limepay-switch input[name=limepay-selection]').prop('checked', userTogglePreselection == 'split');
                    if (userTogglePreselection == 'full') {
                        $('.limepay-pay-onetime').addClass('active');
                        $('.limepay-payin-four').removeClass('active');
                    } else {
                        $('.limepay-pay-onetime').removeClass('active');
                        $('.limepay-payin-four').addClass('active');
                    }
                }
            });
        }
    });
};

module.exports = base;
