'use strict';

/**
 * @namespace Account
 */

var server = require('server');
server.extend(module.superModule);
var limepayUtilsHelpers = require('*/cartridge/scripts/helpers/limepayUtilsHelpers');
var limepayUpsertCustomerService = require('*/cartridge/scripts/services/limepayUpsertCustomerService');

server.append('Login', function (req, res, next) {
    var CustomerMgr = require('dw/customer/CustomerMgr');
    var limepayEnabled = limepayUtilsHelpers.isLimepayPaymentEnabled();

    if (limepayEnabled) {
        var viewData = res.getViewData();
        var email = req.form.loginEmail;
        var customer = CustomerMgr.getCustomerByLogin(email);
        var limepayCustomerId = customer.profile.custom.limepayCustomerId;
        if (!limepayCustomerId) {
            // Limepay create upsert customer API call
            limepayUpsertCustomerService.upsertLimepayCustomer(customer);
        }

        res.setViewData(viewData);
    }
    next();
});

server.append('SubmitRegistration', function (req, res, next) {
    var viewData = res.getViewData();
    var email = viewData.email;
    this.on('route:Complete', function () {
        // Upsert new customer details to Limepay
        var limepayEnabled = limepayUtilsHelpers.isLimepayPaymentEnabled();
        if (limepayEnabled) {
            var CustomerMgr = require('dw/customer/CustomerMgr');
            var customer = CustomerMgr.getCustomerByLogin(email);
            if (customer) {
                // Limepay create upsert customer API call
                limepayUpsertCustomerService.upsertLimepayCustomer(customer);
            }
        }
    });
    return next();
});

module.exports = server.exports();
