'use strict';

var page = module.superModule;

var server = require('server');
server.extend(page);

server.append('Begin', server.middleware.https, function (req, res, next) {
    var viewData = res.getViewData();

    var limepayUtilsHelpers = require('*/cartridge/scripts/helpers/limepayUtilsHelpers');
    var limepaySignInCustomerWithCustomerId = require('*/cartridge/scripts/services/limepaySignInCustomerWithCustomerId');
    var limepayUpsertCustomerService = require('*/cartridge/scripts/services/limepayUpsertCustomerService');
    var AccountModel = require('*/cartridge/models/account');
    var CustomerMgr = require('dw/customer/CustomerMgr');
    var limepayCheckoutAllowed = limepayUtilsHelpers.limepayCheckoutAllowed();
    var limepayPrimaryColor = limepayUtilsHelpers.getPrimaryColor();
    var limepayEnabled = limepayUtilsHelpers.isLimepayPaymentEnabled();
    viewData.limepayCheckoutAllowed = limepayCheckoutAllowed;
    viewData.limepayPrimaryColor = limepayPrimaryColor;
    viewData.limepayCustomerToken = '';
    var requestStage = req.querystring.stage;
    if (requestStage === 'payment') {
        if (limepayEnabled) {
            var accountModel = new AccountModel(req.currentCustomer);
            if (accountModel.registeredUser) {
                var email = accountModel.profile.email;
                var customer = CustomerMgr.getCustomerByLogin(email);
                var limepayCustomerId = customer.profile.custom.limepayCustomerId;
                if (!limepayCustomerId) {
                    // Limepay create upsert customer API call
                    var response = limepayUpsertCustomerService.upsertLimepayCustomer(customer);
                    limepayCustomerId = response.object.customerId;
                }
                if (limepayCustomerId) {
                    // Limepay customer login with customer id API call
                    var response = limepaySignInCustomerWithCustomerId.signInLimepayCustomerWithCustomerId(limepayCustomerId);
                    if (response.ok && response.object) {
                        viewData.limepayCustomerToken = response.object.customToken;
                    }
                }
            }
        }
    }
    res.setViewData(viewData);
    next();
});

module.exports = server.exports();
