'use strict';

var base = module.superModule;

var LimepayModel = require('*/cartridge/scripts/common/limepayModel');
var limepayUtilsHelpers = require('*/cartridge/scripts/helpers/limepayUtilsHelpers.js');

function OrderModel(lineItemContainer, options) {
    base.call(this, lineItemContainer, options);
    if (lineItemContainer) {
        this.limepayOrderData = new LimepayModel(lineItemContainer);
        this.limepayCheckoutContext = limepayUtilsHelpers.getWidgetContextObject();
    }
}

module.exports = OrderModel;
