'use strict';

/* Script Includes */
var limepayCheckoutHelpers = require('~/cartridge/scripts/helpers/limepayCheckoutHelpers');

/**
 * Prepares order information for Limepay checkout form
 * @param {dw.order.Basket} basket - Customer Basket
 * @returns {Object} orderInfo
 */
function getOrderInformation(basket) {
    var orderInfo = {};
    orderInfo.currency = basket.currencyCode;
    var orderAmount = limepayCheckoutHelpers.getNonGiftCertificateAmount(basket);
    orderInfo.amount = parseInt((orderAmount * 100).toFixed(0));
    return orderInfo;
}

/**
 * @constructor
 * @param {dw.order.Basket} basket - customer basket
 */
function LimepayModel(basket) {
    if (basket !== null) {
        this.customerEmail = customer.registered && !empty(customer.profile) ? customer.profile.email : '';
        this.orderInfo = getOrderInformation(basket);
    }
}

module.exports = LimepayModel;
