'use strict';

/**
 * Creates an order at Limepay corresponding to the SFCC order
 * @param {dw.order.Order} order - order being placed
 * @param {dw.order.PaymentInstrument} paymentInstrument - payment instrument of the order
 * @returns {Object} - Limepay create order service response
 */
exports.createLimepayOrder = function (order, paymentInstrument) {
    var ServiceBuilder = require('~/cartridge/scripts/common/limepayServiceBuilder');
    var APIContextLib = require('~/cartridge/scripts/common/limepayAPIContext');
    var LimepayService = require('~/cartridge/scripts/services/limepayService');
    var CommonUtils = require('*/cartridge/scripts/common/limepayCommonUtils');
    var Transaction = require('dw/system/Transaction');

    var clientSecretKey = ServiceBuilder.getClientSecretKey();
    var limepayAPIContext = new APIContextLib();
    var url = limepayAPIContext.getLimepayAPIUrls().get('createOrder');

    var callArgs = {
        secretKey: clientSecretKey,
        urlPath: url,
        type: 'Create Order'
    };

    var requestBody = ServiceBuilder.getCreateOrderRequestBody(order, paymentInstrument);
    var response = LimepayService.call(callArgs, requestBody);

    if (response.ok && response.object) {
        CommonUtils.logDebug('Order created at Limepay with ID : ' + response.object.merchantOrderId);
        Transaction.wrap(function () {
            order.custom.limepayOrderId = response.object.merchantOrderId;
        });
    }

    return response;
};
