'use strict';

var page = module.superModule;

var server = require('server');
server.extend(page);

server.prepend('Start', function (req, res, next) {
    var URLRedirectMgr = require('dw/web/URLRedirectMgr');
    if (URLRedirectMgr.getRedirectOrigin() === '/.well-known/apple-developer-merchantid-domain-association') {
        res.render('util/applepayverification');
        res.setHttpHeader(dw.system.Response.CONTENT_TYPE, 'application/json');
        return this.done(req, res);
    }

    return next();
});

module.exports = server.exports();
