'use strict';

var base = module.superModule;

module.exports = function (basket) {
    base.call(this, basket);

    // Check whether basket contains any pay later disqualifying item
    // and set customer session attribute
    if (basket !== null) {
        var limepayUtilsHelpers = require('*/cartridge/scripts/helpers/limepayUtilsHelpers');
        var disableLimepayPayLater = false;

        var productLineItems = basket.getAllProductLineItems();
        if (!empty(productLineItems)) {
            // Iterate to find disqualifying item
            for (var i = 0; i < productLineItems.length; i++) {
                var product = productLineItems[i].product;
                if (limepayUtilsHelpers.excludeProductPayLater(product)) {
                    disableLimepayPayLater = true;
                    break;
                }
            }
        }

        if (disableLimepayPayLater && !session.custom.disableLimepayPayLater) {
            // Set session attribute value
            session.custom.disableLimepayPayLater = true;
        } else if (!disableLimepayPayLater && 'disableLimepayPayLater' in session.custom) {
            // Clear session attribute value
            delete session.custom.disableLimepayPayLater;
        }

        // Cart data for limepay cart widget, when cart updates
        var limepayCartHelpers = require('*/cartridge/scripts/helpers/limepayCartHelpers');
        Object.defineProperty(this, 'limepayCartData', {
            enumerable: true,
            value: limepayCartHelpers.getLimepayCartData(this)
        });
    } else if ('disableLimepayPayLater' in session.custom) {
        // Clear session attribute value
        delete session.custom.disableLimepayPayLater;
    }
};
