'use strict';

/**
 * Get cart data for limepay widget
 * @param {Object} cart - cart model
 * @return {Object} - limepay cart data
 */
function getLimepayCartData(cart) {
    var limepayUtilsHelpers = require('*/cartridge/scripts/helpers/limepayUtilsHelpers');

    var limepayCartTotal = cart.totals.grandTotalValue;
    var limepayInstallment = ((limepayCartTotal) / 4);

    // Preferred cart widget display mode
    var widgetDisplayMode = limepayUtilsHelpers.getLimepayWidgetDisplayMode('cart');

    var excludePayLaterForCustomer = limepayUtilsHelpers.isPayLaterExcludedForCustomer();
    var bnpCartThresholdExceeds = limepayUtilsHelpers.bnplContextThresholdExceeds('cart');
    // Rendering widget display mode based on current basket products & threshold
    var userWidgetDisplayMode = excludePayLaterForCustomer || bnpCartThresholdExceeds ? 'hidden' : widgetDisplayMode;

    var togglePreselection = limepayUtilsHelpers.getWidgetTogglePreselection();

    return {
        amount: limepayCartTotal,
        installment: limepayInstallment,
        widgetDisplayMode: widgetDisplayMode,
        userWidgetDisplayMode: userWidgetDisplayMode,
        togglePreselection: togglePreselection
    };
}

module.exports = {
    getLimepayCartData: getLimepayCartData
};
