'use strict';

/**
 * Get product total for limepay widget
 * @param {dw.catalog.Product} originalProduct - main product
 * @param {dw.util.ArrayList} productSetList - list of product set, products
 * @returns salesPrice
 */
function getLimepayProductPrice(originalProduct, productSetList) {
    var Money = require('dw/value/Money');
    var PromotionMgr = require('dw/campaign/PromotionMgr');
    var Promotion = require('dw/campaign/Promotion');

    var product = originalProduct;
    var promos = null;
    if (originalProduct && originalProduct.variationGroup) {
        product = originalProduct.masterProduct;
    }

    var productPriceModel = product.priceModel;
    if (product.master && !productPriceModel.isPriceRange() && product.variationModel.variants.size() > 0) {
        product = originalProduct.variationModel.variants[0];
        productPriceModel = product.priceModel;
    }

    var salesPrice = productPriceModel.getPrice();
    if (originalProduct.variationGroup) {
        promos = PromotionMgr.activeCustomerPromotions.getProductPromotions(originalProduct);
    } else {
        promos = PromotionMgr.activeCustomerPromotions.getProductPromotions(product);
    }
    var promotionalPrice = Money.NOT_AVAILABLE;
    if (!empty(promos)) {
        var promo = promos[0];
        if (promo.getPromotionClass() != null && promo.getPromotionClass().equals(Promotion.PROMOTION_CLASS_PRODUCT)) {
            if (product.optionProduct) {
                promotionalPrice = promo.getPromotionalPrice(product, product.getOptionModel());
            } else {
                promotionalPrice = promo.getPromotionalPrice(product);
            }
        }
    }
    if (promotionalPrice.available && salesPrice.compareTo(promotionalPrice) != 0) {
        salesPrice = promotionalPrice;
    }

    if (product.productSet && !empty(productSetList)) {
        salesPrice = new dw.value.Money(0, session.currency.currencyCode);
        for (var i = 0; i < productSetList.length; i++) {
            salesPrice += getLimepayProductPrice(productSetList[i], null);
        }
    } else if ((product.master || product.variationGroup) && productPriceModel.isPriceRange()) {
        salesPrice = product.priceModel.minPrice;
    }

    return salesPrice;
}

module.exports = {
    getLimepayProductPrice: getLimepayProductPrice
};
