'use strict';

/**
 * Sample Controller for triggering refund for a limepay order
 */

/* Script Modules */
var app = require('*/cartridge/scripts/app');
var guard = require('*/cartridge/scripts/guard');

/**
 * Accepts the limepay refund request details via url parameters
 * and executes the limepay refund service, returns json as response
 */
function generate() {
    var CommonUtils = require('*/cartridge/scripts/common/limepayCommonUtils');
    var OrderMgr = require('dw/order/OrderMgr');
    var HookMgr = require('dw/system/HookMgr');
    var Resource = require('dw/web/Resource');

    var orderID = request.httpParameterMap.orderID;
    var refundAmount = request.httpParameterMap.refundAmount;
    var refundResult;
    var order = OrderMgr.getOrder(orderID);

    if (HookMgr.hasHook('limepay.payment.refund')) {
        // Invokes Limepay refund hooks
        refundResult = HookMgr.callHook('limepay.payment.refund', 'ProcessRefund', order, refundAmount);
    }

    var response;
    if (!refundResult.ok) {
        CommonUtils.logError(Resource.msg('limepay.refund.failed', 'limepay', null));
        var errorMessage = CommonUtils.getResponseErrorMsg(refundResult.errorMessage);
        response = {
            error: true,
            message: errorMessage.message,
            detail: errorMessage.detail
        };
    } else {
        response = {
            success: true,
            refundId: refundResult.object.refundId
        };
    }

    app.getView({
        obj: response
    }).render('util/json');
}

/*
 * Web exposed methods
 */
/** Sample endpoint for payment refund
 * @see module:controllers/Login~show */
exports.Generate = guard.ensure(['https'], generate);
