'use strict';

/**
 * Limepay utils helpers
*/
var limepayUtilsHelpers = function () {};
limepayUtilsHelpers.excludeProductPayLater = function (product) {
    if(product.custom.disableLimepayPayLater) {
        return true;
    } else {
        return false;
    }
};

limepayUtilsHelpers.getLimepayWidgetDisplayMode = function () {
    return 'toggle';
};

limepayUtilsHelpers.getWidgetContextObject = function () {
    return {
        isLimepayEnabled: true,
        publicKey: 'some key',
        hidePayLaterOption: false,
        hideFullPayOption: false,
        preselectedPaymentType: 'full',
        preferredPaymentType: 'multiple',
        basketContextURL: 'some URL',
        savePaymentTokenURL: 'some URL',
        saveToggleSelectionURL: 'some URL',
        checkoutCSSOverride: 'some URL',
        bnplCheckoutThresholdExceeds: false
    };
};

module.exports = limepayUtilsHelpers;