'use strict';

var PaymentLogger;

var limepayCommonUtils = {
    /**
	 * Method to log a message
	 * @param {string} msg - Message to be logged
	 */
    logError: function (msg) {
        var Logger = require('dw/system/Logger');

        PaymentLogger = Logger.getLogger('limepay', 'Limepay');
        // PaymentLogger.error(JSON.stringify(msg));
        PaymentLogger.error(msg);
    },

    logDebug: function (msg) {
        var Logger = require('dw/system/Logger');

        PaymentLogger = Logger.getLogger('limepay', 'Limepay');
        // PaymentLogger.error(JSON.stringify(msg));
        PaymentLogger.debug(msg);
    },

    getResponseErrorMsg: function (errorMessage) {
        var errorMessageObj = {};
        try {
            errorMessageObj = JSON.parse(errorMessage);
        } catch (e) {
            this.logError('Could not parse service response ' + errorMessage);
            errorMessageObj = {
                message: 'ERROR : Failed to parse response'
            };
        }
        return errorMessageObj;
    }
};

module.exports = limepayCommonUtils;
