/**
 * Remove all previous payment instruments from the basket
 *
 * @input Basket : dw.order.Basket The basket
 *
 */
function removePaymentInstruments(basket) {
    if (!basket) {
        return { error: true };
    }

    var PaymentInstrument = require('dw/order/PaymentInstrument');

    // Current basket payment instruments
    const paymentInstruments = basket.getPaymentInstruments();
    const itr = paymentInstruments.iterator();

    // Remove all existing payment instruments
    while (itr.hasNext()) {
        var paymentInstrument = itr.next();
        // Avoid removing payment instrument if it is of type gift certificate
        if (!PaymentInstrument.METHOD_GIFT_CERTIFICATE.equals(paymentInstrument.getPaymentMethod())) {
            basket.removePaymentInstrument(paymentInstrument);
        }
    }

    return { error: false };
}

function getNonGiftCertificateAmount(lineItemCtnr) {
    var Money = require('dw/value/Money');

    // The total redemption amount of all gift certificate payment instruments in the basket
    var giftCertTotal = new Money(0.0, lineItemCtnr.getCurrencyCode());

    // Gets the list of all gift certificate payment instruments
    var gcPaymentInstrs = lineItemCtnr.getGiftCertificatePaymentInstruments();
    var iter = gcPaymentInstrs.iterator();
    var orderPI = null;

    // Sums the total redemption amount
    while (iter.hasNext()) {
        orderPI = iter.next();
        giftCertTotal = giftCertTotal.add(orderPI.getPaymentTransaction().getAmount());
    }

    // Gets the order total
    var orderTotal = new Money(0, session.currency.currencyCode);
    if (lineItemCtnr.totalGrossPrice.available) {
        orderTotal = lineItemCtnr.getTotalGrossPrice();
    } else {
        orderTotal = lineItemCtnr.getAdjustedMerchandizeTotalPrice(true).add(lineItemCtnr.giftCertificateTotalPrice);
    }

    // Calculates the amount to charge for the payment instrument.
    // This is the remaining open order total that must be paid.
    var amountOpen = orderTotal.subtract(giftCertTotal);

    // Returns the open amount to be paid.
    return amountOpen;
}

module.exports = {
    removePaymentInstruments: removePaymentInstruments,
    getNonGiftCertificateAmount: getNonGiftCertificateAmount
};
