'use strict';

var base = require('base/checkout/billing');
var formHelpers = require('base/checkout/formErrors');


/**
 * @function
 * @description Initialize the Lime Payment tab with lime pay payment form
 */
base.paymentTabsInit = function () {
    $('.payment-options .nav-item').off().on('click', function (e) {
        e.preventDefault();
        var methodID = $(this).data('method-id');
        var paymentMethodIds = ['Limepay'];
        var paymentMethod = $.inArray(methodID, paymentMethodIds) > -1;
        formHelpers.clearPreviousErrors('.payment-form');
        if (paymentMethod) {
            $('body').trigger('limePayment:handlePaymentTabEvents');
        } else {
            $('body').trigger('limePayment:resetLimePayPaymentTab');
        }
    });
};

/**
 * @function
 * @description event listener when edit the payment form
 */
base.editBillingSummary = function () {
    $('.payment-summary .edit-button').on('click', function () {
        $('body').trigger('limePayment:handleEditBillingSummary');
    });
};

/**
 * Updates the payment information in checkout, based on the supplied order model
 * @param {Object} order - checkout model to use as basis of new truth
 */
base.methods.updatePaymentInformation = function (order) {
    // update payment details
    var $paymentSummary = $('.payment-details');
    var htmlToAppend = '';

    if (order.billing.payment
        && order.billing.payment.selectedPaymentInstruments
        && order.billing.payment.selectedPaymentInstruments.length > 0
        && order.billing.payment.selectedPaymentInstruments[0].paymentMethod === 'Limepay'
        && order.billing.payment.selectedPaymentInstruments[0].name) {
        htmlToAppend
        += `<div><span>${
                order.billing.payment.selectedPaymentInstruments[0].name
            }</span></div>`;
    } else if (order.billing.payment && order.billing.payment.selectedPaymentInstruments
        && order.billing.payment.selectedPaymentInstruments.length > 0
        && order.billing.payment.selectedPaymentInstruments[0].paymentMethod === 'CREDIT_CARD') {
        htmlToAppend += '<span>' + order.resources.cardType + ' '
            + order.billing.payment.selectedPaymentInstruments[0].type
            + '</span><div>'
            + order.billing.payment.selectedPaymentInstruments[0].maskedCreditCardNumber
            + '</div><div><span>'
            + order.resources.cardEnding + ' '
            + order.billing.payment.selectedPaymentInstruments[0].expirationMonth
            + '/' + order.billing.payment.selectedPaymentInstruments[0].expirationYear
            + '</span></div>';
    }

    $paymentSummary.empty().append(htmlToAppend);
};

/**
 * Updates the payment information in checkout, based on the supplied order model
 * @param {Object} order - checkout model to use as basis of new truth
 */
base.methods.initLimePay3DS = function (threeDSData, defer) {
    // Intialize 3DS flow, display action prompt
    if (window.LimepayCheckout && threeDSData && threeDSData.paymentResult.paymentActionRequired) {
        LimepayCheckout.handlePaymentActionRequired(
            threeDSData.paymentResult.paymentActionRequired, // from PayOrder HTTP 403 error response
            function () {
                $.ajax({
                    url: threeDSData.threeDSURL,
                    type: 'POST',
                    success: function (data) {
                        if (data.error) {
                            defer.reject(data);
                        } else {
                            var paymentResult = data.paymentResult || {};

                            if (paymentResult.paymentActionRequired) {
                                base.methods.initLimePay3DS(data, defer);
                            } else {
                                var redirect = $('<form>')
                                .appendTo(document.body)
                                .attr({
                                    method: 'POST',
                                    action: data.continueUrl
                                });

                            $('<input>')
                                .appendTo(redirect)
                                .attr({
                                    name: 'orderID',
                                    value: data.orderID
                                });

                            $('<input>')
                                .appendTo(redirect)
                                .attr({
                                    name: 'orderToken',
                                    value: data.orderToken
                                });

                            redirect.submit();
                            defer.resolve(data);
                            }
                        }
                    },
                    error: function (err) {
                        defer.reject();
                    }
                });
              // action completed, reattempt PayOrder request
            },
            function (error) {
                defer.reject();
            }
          );
    }
};

module.exports = base;
