'use strict';

var base = module.superModule;
var limepayUtilsHelpers = require('*/cartridge/scripts/helpers/limepayUtilsHelpers');
var limepayProductHelpers = require('~/cartridge/scripts/helpers/limepayProductHelpers');

module.exports = function (product, apiProduct, options, factory) {
    base.call(this, product, apiProduct, options, factory);
    var excludeProductPayLater = limepayUtilsHelpers.excludeProductPayLater(apiProduct);

    Object.defineProperty(product, 'excludeProductPayLater', {
        enumerable: true,
        value: excludeProductPayLater
    });

    Object.defineProperty(product, 'widgetDisplayMode', {
        enumerable: true,
        value: excludeProductPayLater ? 'hidden' : limepayUtilsHelpers.getLimepayWidgetDisplayMode('product')
    });

    Object.defineProperty(product, 'limepayProductData', {
        enumerable: true,
        value: limepayProductHelpers.getLimepayProductData(product.price)
    });
    return product;
};
