'use strict';

/**
 * Get product total for limepay widget
 * @param {Object} price Price model
 * @return {string} formatted installment string
 */
function getLimepayProductPrice(price) {
    var productPrice = null;
    if (price.type === 'tiered') {
        productPrice = new Number(price.startingFromPrice.sales.decimalPrice);
    } else if (price.type === 'range') {
        productPrice = new Number(price.min.sales.decimalPrice);
    } else {
        productPrice = new Number(price.sales.decimalPrice);
    }
    return productPrice;
}

/**
 * Get product data for limepay widget
 * @param {Object} price Price model
 * @return {Object} - limepay product data
 */
function getLimepayProductData(price) {
    var Money = require('dw/value/Money');
    var Currency = require('dw/util/Currency');

    // Product full amount
    var limepayProductPrice = getLimepayProductPrice(price);

    var currencyCode = session.currency.currencyCode;
    var currencySymbol = Currency.getCurrency(currencyCode).getSymbol();
    var limepayMoneyObj = new Money(limepayProductPrice, currencyCode);

    // Product pay later split amount
    var limepayInstallment = ((limepayMoneyObj.decimalValue) / 4);

    return {
        amount: limepayProductPrice,
        currencySymbol: currencySymbol,
        installment: limepayInstallment
    };
}

module.exports = {
    getLimepayProductData: getLimepayProductData
};
