'use strict';

var server = require('server');

/**
 * Sample route to test limepay refund services
 * @name Base/CheckoutServices-PlaceOrder
 * @function
 * @memberof CheckoutServices
 * @param {middleware} - server.middleware.https
 * @param {category} - sensitive
 * @param {returns} - json
 * @param {serverfunction} - get
 */
server.get('Generate', server.middleware.https, function (req, res, next) {
    var CommonUtils = require('*/cartridge/scripts/common/limepayCommonUtils');
    var OrderMgr = require('dw/order/OrderMgr');
    var HookMgr = require('dw/system/HookMgr');
    var Resource = require('dw/web/Resource');

    var orderID = request.httpParameterMap.orderID;
    var refundAmount = request.httpParameterMap.refundAmount;
    var refundResult;
    var order = OrderMgr.getOrder(orderID);

    if (HookMgr.hasHook('limepay.payment.refund')) {
        // Invokes Limepay refund hooks
        refundResult = HookMgr.callHook('limepay.payment.refund', 'ProcessRefund', order, refundAmount);
    }

    if (!refundResult.ok) {
        CommonUtils.logError(Resource.msg('limepay.refund.failed', 'limepay', null));
        var errorMessage = CommonUtils.getResponseErrorMsg(refundResult.errorMessage);
        res.json({
            error: true,
            message: errorMessage.message,
            detail: errorMessage.detail
        });
    } else {
        res.json({
            success: true,
            refundId: refundResult.object.refundId
        });
    }

    next();
});

module.exports = server.exports();
