var assert = require('chai').assert;
var request = require('request');
var requestPromise = require('request-promise');
var config = require('../it.config');
var chai = require('chai');

describe('Limepay-UserToggleState', function () {
    this.timeout(5000);

    request = request.defaults({
        baseUrl: config.baseUrl,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        rejectUnauthorized: false,
        jar: true,
        json: true
    });

    var UserToggleState = {
        method: 'GET',
        uri: 'Limepay-UserToggleState',
    };

    it('should load user toggle preselection', function (done) {
        request(UserToggleState, function (error, response, jsonResponse) {
            if (error) done(error);
            assert.equal(response.statusCode, 200, 'Expected statusCode to be 200.');
            done();
        });
    });
});

describe('Limepay-SaveSelection', function () {
    this.timeout(5000);

    request = request.defaults({
        baseUrl: config.baseUrl,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        rejectUnauthorized: false,
        jar: true,
        json: true
    });

    var UserToggleState = {
        method: 'GET',
        uri: 'Limepay-SaveSelection?limepayToggle=full',
    };

    it('should save user toggle selection', function (done) {
        request(UserToggleState, function (error, response, jsonResponse) {
            if (error) done(error);
            assert.equal(response.statusCode, 200, 'Expected statusCode to be 200.');
            done();
        });
    });
});

describe('Limepay-SavePaymentToken', function () {
    this.timeout(10000);

    var variantId = '701643566785M';
    var quantity = 1;
    var cookieJar = requestPromise.jar();
    var cookieString;

    it('should save Limepay payment token to basket', function () {
        var myRequest = {
            url: '',
            method: 'POST',
            rejectUnauthorized: false,
            resolveWithFullResponse: true,
            jar: cookieJar,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        };

        myRequest.url = config.baseUrl + '/Cart-AddProduct';
        myRequest.form = {
            pid: variantId,
            quantity: quantity
        };

        // ---- adding product to Cart
        return requestPromise(myRequest)
            .then(function (response) {
                assert.equal(response.statusCode, 200, 'Expected add to Cart request statusCode to be 200.');
                cookieString = cookieJar.getCookieString(myRequest.url);
            })
            // ---- go to checkout
            .then(function (response) {
                myRequest.url = config.baseUrl + '/Checkout-Begin';
                myRequest.method = 'GET';
                return requestPromise(myRequest);
            })
            // ---- csrf token generation
            .then(function (response) {
                myRequest.method = 'POST';
                myRequest.url = config.baseUrl + '/CSRF-Generate';
                var cookie = request.cookie(cookieString);
                cookieJar.setCookie(cookie, myRequest.url);
                return requestPromise(myRequest);
            })
            // ---- set shipping address
            .then(function (csrfResponse) {
                var csrfJsonResponse = JSON.parse(csrfResponse.body);
                myRequest.method = 'POST';
                myRequest.url = config.baseUrl + '/CheckoutShippingServices-SubmitShipping?' +
                    csrfJsonResponse.csrf.tokenName + '=' +
                    csrfJsonResponse.csrf.token;
                myRequest.form = {
                    dwfrm_shipping_shippingAddress_addressFields_firstName: 'Thomas',
                    dwfrm_shipping_shippingAddress_addressFields_lastName: 'A Lyall',
                    dwfrm_shipping_shippingAddress_addressFields_address1: '42 Healy Road',
                    dwfrm_shipping_shippingAddress_addressFields_address2: '',
                    dwfrm_shipping_shippingAddress_addressFields_country: 'AU',
                    dwfrm_shipping_shippingAddress_addressFields_states_stateCode: 'WA',
                    dwfrm_shipping_shippingAddress_addressFields_city: 'BALBARRUP',
                    dwfrm_shipping_shippingAddress_addressFields_postalCode: '6258',
                    dwfrm_shipping_shippingAddress_addressFields_phone: '(08) 9054 4492',
                    dwfrm_shipping_shippingAddress_shippingMethodID: 'Standerd-AU'
                };
                return requestPromise(myRequest);
            })
             // --- response of submitshipping
             .then(function (response) {
                assert.equal(response.statusCode, 200, 'Expected CheckoutShippingServices-SubmitShipping statusCode to be 200.');
            })
            // ---- get limepay basket context to load payment form
            .then(function (response) {
                myRequest.url = config.baseUrl + '/Limepay-BasketContext';
                myRequest.method = 'GET';
                return requestPromise(myRequest);
            })
            // --- response of limepay get basket context
            .then(function (response) {
                assert.equal(response.statusCode, 200, 'Expected Limepay-BasketContext statusCode to be 200.');
            })
            // ---- csrf token generation
            .then(function () {
                myRequest.method = 'POST';
                myRequest.url = config.baseUrl + '/CSRF-Generate';
                var cookie = request.cookie(cookieString);
                cookieJar.setCookie(cookie, myRequest.url);
                return requestPromise(myRequest);
            })
            // --- save payment token to basket
            .then(function (csrfResponse) {
                var csrfJsonResponse = JSON.parse(csrfResponse.body);
                myRequest.method = 'POST';
                myRequest.url = config.baseUrl + '/Limepay-SavePaymentToken?' +
                    csrfJsonResponse.csrf.tokenName + '=' +
                    csrfJsonResponse.csrf.token;
                myRequest.form = {
                    paymentToken: 'TestToken123',
                    phone: '+61890544492'
                };
                return requestPromise(myRequest);
            })
            // response of save payment token to basket
            .then(function (response) {
                var responseJson = JSON.parse(response.body);

                var expectedResBody = {
                    success: true
                };

                assert.equal(response.statusCode, 200, 'Expected KlarnaPayments-SelectPaymentMethod statusCode to be 200.');
                assert.equal(responseJson.success, expectedResBody.success, 'Expected success status is true.');
            });
    });
});