'use strict';


var assert = require('chai').assert;
var proxyquire = require('proxyquire').noCallThru().noPreserveCache();
var mockSuperModule = require('../../../mockModuleSuperModule');
var baseHelpers = require('../../../../mocks/helpers/baseHelpers');

var productBundleMock1 = {
    price: {
        type: 'some value',
        sales: {
            value: 60.00
        }
    },
    custom: {
        disableLimepayPayLater: false
    }
};

var limepayUtilsHelpers;
var limepayProductHelpers;
var fullProduct;

describe('Product Bundle Model', function () {
    before(function () {
        mockSuperModule.create(baseHelpers);

        limepayUtilsHelpers = proxyquire('../../../../mocks/scripts/helpers/limepayUtilsHelpers', {
            'dw/system/Site': {}
        });

        limepayProductHelpers = require('../../../../mocks/scripts/helpers/limepayProductHelpers');

        fullProduct = proxyquire('../../../../../cartridges/int_limepay_sfra/cartridge/models/product/productBundle', {
            '*/cartridge/scripts/helpers/limepayUtilsHelpers': limepayUtilsHelpers,
            '~/cartridge/scripts/helpers/limepayProductHelpers': limepayProductHelpers
        });
    });

    after(function () {
        mockSuperModule.remove();
    });

    it('should return an object containing Limepay exclude pay later elligibility status, widget mode and payment details for product bundle', function () {
        var obj = {};
        fullProduct(obj, productBundleMock1);
        assert.isFalse(obj.excludeProductPayLater);
        assert.equal(obj.widgetDisplayMode, 'toggle');

        var response = {
            amount: 60,
            currencySymbol: 'AUD',
            installment: 15
        };
        assert.deepEqual(obj.limepayProductData, response);
    });

});