'use strict';


var assert = require('chai').assert;
var proxyquire = require('proxyquire').noCallThru().noPreserveCache();
var mockSuperModule = require('../../../mockModuleSuperModule');
var baseHelpers = require('../../../../mocks/helpers/baseHelpers');

var productMock1 = {
    custom: {
        disableLimepayPayLater: false
    }
};

var limepayUtilsHelpers;
var productLineItem;

describe('Product Line Item Model', function () {
    before(function () {
        mockSuperModule.create(baseHelpers);

        limepayUtilsHelpers = proxyquire('../../../../mocks/scripts/helpers/limepayUtilsHelpers', {
            'dw/system/Site': {}
        });

        productLineItem = proxyquire('../../../../../cartridges/int_limepay_sfra/cartridge/models/productLineItem/productLineItem', {
            '*/cartridge/scripts/helpers/limepayUtilsHelpers': limepayUtilsHelpers
        });
    });

    after(function () {
        mockSuperModule.remove();
    });

    it('should return an object containing Limepay exclude pay later elligibility status for product line item', function () {
        var obj = {};
        productLineItem(obj, productMock1);
        assert.isFalse(obj.excludeProductPayLater);
    });

});